using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using System.Net;

namespace PI.ZB.N1201.BaseCMS.WebApplication
{
    public class Feedback : Gemini.Core.WebApplication.Base.WebPageComponent
    {
        public Feedback(Gemini.Core.WebApplication.Interface.IWebPageComponentParam WebPageComponentParam) : base(WebPageComponentParam) { }

        private bool _isConfirm = false;

        public override long ClientID
        {
            get { return BL.Dictionary.Clients.Feedback_PlugIn; }
        }

        private bool _messageSent = false;
        public override bool Save()
        {
            try
            {
                string _feedback_name = this.Environment.Request.Params["feedback_name"];
                string _feedback_email = this.Environment.Request.Params["feedback_email"];
                string _feedback_message = this.Environment.Request.Params["feedback_message"];
                if ((_feedback_name != null) && (_feedback_email != null) && (_feedback_message != null))
                {
                    if (WebPageEngine.IsUserAuthorized)
                    {
                        StringBuilder _sb = new StringBuilder();

                        PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = new N1200.ELearning.BL.ZSBELearning(Environment);
                        PI.ZB.N1200.ELearning.BL.BO.Student _student = _blZSBELearning.Student.RestoreByUser(Environment.User);

                        if (_student != null)
                        {
                            _sb = new StringBuilder();

                            _sb.AppendLine(String.Format("Ucze {0} {1}", _student.Surename, _student.Forename));

                            PI.ZB.N1200.ELearning.BL.BO.Class _class = _blZSBELearning.Class.Restore(_student);

                            if(_class != null)
                            {
                                _sb.AppendLine(String.Format("Klasa {0}", _class.Name));

                                PI.ZB.N1200.ELearning.BL.BO.Instructor _instructor = _blZSBELearning.Instructor.Restore(_class);

                                if (_instructor != null)
                                {
                                    _sb.AppendLine(String.Format("Nauczyciel {0} {1}", _instructor.Surename, _instructor.Forename));
                                }


                                PI.ZB.N1200.ELearning.BL.BO.School _school = _blZSBELearning.School.Restore(_class);

                                if (_school != null)
                                {
                                    _sb.AppendLine(String.Format("Szkoa {0}", _school.Name));
                                }
                            }
                            
                        }
                        else
                        {
                            PI.ZB.N1200.ELearning.BL.BO.Instructor _instructor = _blZSBELearning.Instructor.RestoreByUser(Environment.User);
                            if (_instructor != null)
                            {
                                _sb.AppendLine(String.Format("Nauczyciel {0} {1}", _instructor.Surename, _instructor.Forename));

                                PI.ZB.N1200.ELearning.BL.BO.School _school = _blZSBELearning.School.Restore(_instructor);

                                if (_school != null)
                                {
                                    _sb.AppendLine(String.Format("Szkoa {0}", _school.Name));
                                }
                            }
                        }

                        _sb.AppendLine();
                        _sb.AppendLine(_feedback_message);

                        _feedback_message = _sb.ToString();
                    }

                    PI.ZB.N1201.BaseCMS.BL.Feedback _blFeedback = new PI.ZB.N1201.BaseCMS.BL.Feedback(Environment);
                    _messageSent = _blFeedback.SendEmail(_feedback_name, _feedback_email, _feedback_message);
                }
                return _messageSent;
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName,_exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
                throw _exception;
            }
        }

        public override void Load()
        {
            try
            {
                XML.Element.Start("Message");
                XML.Element.Attribute("messageSent", _messageSent);
                XML.Element.End();
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName,_exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
                throw _exception;
            }
        }

        public override bool IsParamKey(long ParamKey)
        {
            switch (ParamKey)
            {
                case (Gemini.Dictionary.WebPageComponent.Param.DisplayParentContent): return true;
                default: return false;
            }
        }

        public override object GetParamKey(long ParamKey, params object[] Params)
        {
            switch (ParamKey)
            {
                case (Gemini.Dictionary.WebPageComponent.Param.DisplayParentContent): return !_isConfirm;
                default: return null;
            }
        }

        public override bool IsValid
        {
            get
            {
                return true;
            }
        }
    }
}
